// tokdumpsrv.cpp : Implementacja DLL Exports.


// Uwaga: Informacje Proxy/Stub
//        Aby utworzy oddzielny plik DLL proxy/stub, 
//        naley wykona nmake -f tokdumpsrvps.mk w katalogu projektu.

#include "stdafx.h"
#include "resource.h"
#include <initguid.h>
#include "tokdumpsrv.h"

#include "tokdumpsrv_i.c"
#include "TokDump.h"


CComModule _Module;

BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_TokDump, CTokDump)
END_OBJECT_MAP()

/////////////////////////////////////////////////////////////////////////////
// Punkt wejcia DLL

extern "C"
BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
    if (dwReason == DLL_PROCESS_ATTACH)
    {
        _Module.Init(ObjectMap, hInstance, &LIBID_TOKDUMPSRVLib);
        DisableThreadLibraryCalls(hInstance);
    }
    else if (dwReason == DLL_PROCESS_DETACH)
        _Module.Term();
    return TRUE;    // ok
}

/////////////////////////////////////////////////////////////////////////////
// Ustalenie czy DLL moe by usunity przez OLE

STDAPI DllCanUnloadNow(void)
{
    return (_Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Zwraca fabryk klas do utworzenia obiektu danego typu

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
    return _Module.GetClassObject(rclsid, riid, ppv);
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - dodaje wpisy do rejestru systemowego

STDAPI DllRegisterServer(void)
{
    // registers object, typelib and all interfaces in typelib
    return _Module.RegisterServer(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// DllUnregisterServer - usuwa wpisy z rejestru systemowego

STDAPI DllUnregisterServer(void)
{
    return _Module.UnregisterServer(TRUE);
}


